/*
AVR UART debug library based on various open source examples.
Copyright (C) 2015  Andreas Fiessler, fornax@leyanda.de

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/
#include <stdlib.h>
#include <avr/io.h>
#include <inttypes.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <stdbool.h>

void usart_init( uint16_t ubrr)
{
    UBRR0H = (uint8_t)(ubrr>>8);
    UBRR0L = (uint8_t)ubrr;

    UCSR0B = (1<<RXEN0)|(1<<TXEN0);

    UCSR0C = (3<<UCSZ00);
}

void usart_putchar(char data) 
{
    // Wait for empty transmit buffer
    while ( !(UCSR0A & (_BV(UDRE0))) );

    UDR0 = data;
}

char usart_getchar(void) 
{
    while ( !(UCSR0A & (_BV(RXC0))) );

    return UDR0;
}

unsigned char usart_kbhit(void) 
{
    //return nonzero if char waiting polled version
    unsigned char b;
    b=0;
    if(UCSR0A & (1<<RXC0)) b=1;
    return b;
}

void usart_pstr(char *s) 
{
    while (*s) {
        usart_putchar(*s);
        s++;
    }
}

int usart_putchar_printf(char var, FILE *stream) 
{
    // translate \n to \r for br@y++ terminal
    if (var == '\n') usart_putchar('\r');
    usart_putchar(var);
    return 0;
}

