/*
Very basic LCD library for use with hd44780 type LCDs.
Copyright (C) 2015  Andreas Fiessler, fornax@leyanda.de

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/
#include "lcdlib.h"
#include <util/delay.h>

void lcd_enable(void)
{
	L_PORT |= (1 << L_E);
	_delay_us(1);
	L_PORT &= ~(1 << L_E);
}

/* 4 bit mode only */
void lcd_send(uint8_t cmd)
{
	L_PORT &= ~(1 << L_DB7);
	L_PORT &= ~(1 << L_DB6);
	L_PORT &= ~(1 << L_DB5);
	L_PORT &= ~(1 << L_DB4);
        if(cmd & 0x80) L_PORT |= (1 << L_DB7);
        if(cmd & 0x40) L_PORT |= (1 << L_DB6);
        if(cmd & 0x20) L_PORT |= (1 << L_DB5);
        if(cmd & 0x10) L_PORT |= (1 << L_DB4);

        lcd_enable();

	L_PORT &= ~(1 << L_DB7);
	L_PORT &= ~(1 << L_DB6);
	L_PORT &= ~(1 << L_DB5);
	L_PORT &= ~(1 << L_DB4);
        if(cmd & 0x08) L_PORT |= (1 << L_DB7);
        if(cmd & 0x04) L_PORT |= (1 << L_DB6);
        if(cmd & 0x02) L_PORT |= (1 << L_DB5);
        if(cmd & 0x01) L_PORT |= (1 << L_DB4);
        lcd_enable();

	_delay_us(42);

}

void lcd_data(uint8_t cmd)
{
	L_PORT |= (1 << L_RS);
	lcd_send(cmd);
	L_PORT &= ~(1 << L_RS); //not sure
}

void lcd_cmd(uint8_t cmd)
{
	L_PORT &= ~(1 << L_RS);
	lcd_send(cmd);
}

void set_cursor(uint8_t x, uint8_t y)
{
	uint8_t cmd;

	switch (y) {
	    case 1: cmd=0x80+0x00+x; break;
	    case 2: cmd=0x80+0x40+x; break;
	    case 3: cmd=0x80+0x10+x; break;
	    case 4: cmd=0x80+0x50+x; break;
	default: return;
	}
	lcd_cmd(cmd);
}
	
void lcd_init(void)
{
	L_PORT &= ~((1 << L_DB4) | (1 << L_DB5) | (1 << L_DB6) | (1 << L_DB7) | (1 << L_E) | (1 << L_RS));
	_delay_ms(15);
	L_PORT |= (1 << L_DB4) | (1 << L_DB5);

	lcd_enable();
	_delay_ms(10);

	lcd_enable();
	_delay_ms(1);

	lcd_enable();
	_delay_ms(1);

	//set 4bit mode	
	L_PORT &= ~((1 << L_DB4) | (1 << L_DB5) | (1 << L_RS));
	L_PORT |= (1 << L_DB5);
	lcd_enable();

	lcd_cmd(0x28); //4 bit mode, 2 lines, 5x7
	lcd_cmd(0x08); // display off
	lcd_cmd(0x01); //display clear
	_delay_ms(2); //display clear takes 1.64 ms
	lcd_cmd(0x06); //cursor increase, no shift 
	lcd_cmd(DISP_ON); //disp on
}

void lcd_clr(void)
{
	L_PORT &= ~((1 << L_DB4) | (1 << L_DB5) | (1 << L_DB6) | (1 << L_DB7) | (1 << L_E) | (1 << L_RS));
	lcd_enable();
	L_PORT |= (1 << L_DB4); 
	lcd_enable();
	_delay_ms(2);
}

void lcd_home(void)
{
	L_PORT &= ~((1 << L_DB4) | (1 << L_DB5) | (1 << L_DB6) | (1 << L_DB7) | (1 << L_E) | (1 << L_RS));
	lcd_enable();
	L_PORT |= (1 << L_DB5); 
	lcd_enable();
	_delay_ms(2);
}
	
void lcd_puts(char *string)
{
	while(*string) {
	    lcd_data(*string);
	    string++;
	}
}
